<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

include '../config.php'; // database connection

$response = array();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ChefID'])) {
    $chefId = $_POST['ChefID'];
    $limit = isset($_POST['Limit']) ? intval($_POST['Limit']) : 0;

   $query = "SELECT 
  r.ReviewText, 
  r.Rating, 
  r.CreatedAt,
  COALESCE(u.FirstName, 'Deleted User') AS UserName
FROM Reviews r
LEFT JOIN Users u ON r.UserID = u.Id
WHERE r.ChefID = ? 
  AND r.IsActive = 1
ORDER BY r.ReviewID DESC;
";

    if ($limit > 0) {
        $query .= " LIMIT ?";
        $stmt = $connection->prepare($query);
        $stmt->bind_param("si", $chefId, $limit);
    } else {
        $stmt = $connection->prepare($query);
        $stmt->bind_param("s", $chefId);
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $reviews = [];

        while ($row = $result->fetch_assoc()) {
            $reviews[] = $row;
        }

        $response['success'] = true;
        $response['data'] = $reviews;
    } else {
        $response['success'] = false;
        $response['message'] = "Failed to fetch reviews.";
    }

    $stmt->close();
} else {
    $response['success'] = false;
    $response['message'] = "Missing ChefID.";
}

echo json_encode($response);
$connection->close();
?>
